// XISLInputTag.cpp: CXISLInputTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLInputTag.h"
#include "XISLVarList.h"
#include "XISLVar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLInputTag::CXISLInputTag()
{
	m_nTagType = ID_TAG_INPUT;
}

CXISLInputTag::~CXISLInputTag()
{
}

CXISLInputTag::CXISLInputTag(const CXISLInputTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nInputType = cpXISL.m_nInputType;
	m_nEvent = cpXISL.m_nEvent;
	m_strMatch = cpXISL.m_strMatch;
}

CXISLInputTag& CXISLInputTag::operator=(const CXISLInputTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nInputType = cpXISL.m_nInputType;
		m_nEvent = cpXISL.m_nEvent;
		m_strMatch = cpXISL.m_strMatch;
	}
	return *this;
}

LPCTSTR CXISLInputTag::GetMatch()
{
	return m_strMatch;
}

//LPCTSTR CXISLOprTag::GetXISLString()
//@\@FinputȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLInputTag::GetXISLString()
{
	CString strInputType = XISL_INPUTTYPE[m_nInputType];

	m_strXISL = "<input type=\"" + strInputType;
	m_strXISL += "\" event=\"";
	m_strXISL += XISL_INPUTEVENT[m_nEvent];
	if(!m_strMatch.IsEmpty())
	{
		m_strXISL += "\" match=\"";
		m_strXISL += m_strMatch;
	}
	m_strXISL += "\" />\r\n";

	return m_strXISL;
}


//BOOL CXISLInputTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLInputTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_INPUT];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

